/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_777;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

@Environment(value=EnvType.CLIENT)
public class OverlayRendering {
    private static final class_5819 random = class_5819.method_43047();
    private static boolean shaderOverlayWarned = false;

    public static boolean shouldRenderOverlay(Portal portal) {
        BreakablePortalEntity breakablePortalEntity;
        if (portal instanceof BreakablePortalEntity && (breakablePortalEntity = (BreakablePortalEntity)portal).getActualOverlay() != null) {
            return breakablePortalEntity.isInFrontOfPortal(CHelper.getCurrentCameraPos());
        }
        return false;
    }

    public static void onRenderPortalEntity(Portal portal, class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        if (IrisInterface.invoker.isShaders()) {
            if (!shaderOverlayWarned) {
                shaderOverlayWarned = true;
                CHelper.printChat("[Immersive Portals] Portal overlay cannot be rendered with shaders");
            }
            return;
        }
        if (portal instanceof BreakablePortalEntity) {
            OverlayRendering.renderBreakablePortalOverlay((BreakablePortalEntity)portal, RenderStates.getPartialTick(), matrixStack, vertexConsumerProvider);
        }
    }

    public static List<class_777> getQuads(class_1087 model, class_2680 blockState, class_243 portalNormal) {
        class_2350 facing = class_2350.method_10142((double)portalNormal.field_1352, (double)portalNormal.field_1351, (double)portalNormal.field_1350);
        ArrayList<class_777> result = new ArrayList<class_777>();
        result.addAll(model.method_4707(blockState, facing, random));
        result.addAll(model.method_4707(blockState, null, random));
        if (result.isEmpty()) {
            for (class_2350 direction : class_2350.values()) {
                result.addAll(model.method_4707(blockState, direction, random));
            }
        }
        return result;
    }

    private static void renderBreakablePortalOverlay(BreakablePortalEntity portal, float partialTick, class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        BreakablePortalEntity.OverlayInfo overlay = portal.getActualOverlay();
        if (overlay == null) {
            return;
        }
        class_2680 blockState = overlay.blockState();
        class_243 cameraPos = CHelper.getCurrentCameraPos();
        if (blockState == null) {
            return;
        }
        class_776 blockRenderManager = class_310.method_1551().method_1541();
        BlockPortalShape blockPortalShape = portal.blockPortalShape;
        if (blockPortalShape == null) {
            return;
        }
        matrixStack.method_22903();
        class_243 offset = portal.getNormal().method_1021(overlay.offset());
        class_243 pos = portal.method_19538();
        matrixStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        class_1087 model = blockRenderManager.method_3349(blockState);
        class_1921 renderLayer = class_4722.method_24076();
        class_4588 buffer = vertexConsumerProvider.getBuffer(renderLayer);
        List<class_777> quads = OverlayRendering.getQuads(model, blockState, portal.getNormal());
        random.method_43052(0L);
        for (class_2338 blockPos : blockPortalShape.area) {
            matrixStack.method_22903();
            matrixStack.method_22904((double)blockPos.method_10263() - pos.field_1352, (double)blockPos.method_10264() - pos.field_1351, (double)blockPos.method_10260() - pos.field_1350);
            if (overlay.rotation() != null) {
                matrixStack.method_22907(overlay.rotation().toMcQuaternion());
            }
            for (class_777 quad : quads) {
                SodiumInterface.invoker.markSpriteActive(quad.method_35788());
                buffer.method_22920(matrixStack.method_23760(), quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1.0f, 1.0f, 1.0f, (float)overlay.opacity(), new int[]{0xE000F0, 0xE000F0, 0xE000F0, 0xE000F0}, class_4608.field_21444, true);
            }
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }
}

